<?php
class ControllerModuleAffiliatepro extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('module/affiliatepro');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('affiliatepro', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');
			if(version_compare(VERSION, '2', '<=')){
				$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
			}else{
				$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'] . '&type=module', true));
			}
		}

		$data['heading_title'] = $this->language->get('heading_title');

		// /$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_status'] = $this->language->get('entry_status');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'separator' => false,
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'separator' => ' :: ',			
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'separator' => ' :: ',
			'href' => $this->url->link('module/affiliatepro', 'token=' . $this->session->data['token'], true)
		);

		$data['action'] = $this->url->link('module/affiliatepro', 'token=' . $this->session->data['token'], true);

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'] . '&type=module', true);

		if (isset($this->request->post['affiliatepro_status'])) {
			$data['affiliatepro_status'] = $this->request->post['affiliatepro_status'];
		} else {
			$data['affiliatepro_status'] = $this->config->get('affiliatepro_status');
		}

		if(version_compare(VERSION, '2', '<=')){
			$this->data = $data;
			$this->template = 'module/affiliate_pro15.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);	
			$this->response->setOutput($this->render());
		}else {
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			if(version_compare(VERSION, '2.2', '<=')){
				$this->response->setOutput($this->load->view('module/affiliatepro.tpl', $data));
			}else{
				$this->response->setOutput($this->load->view('module/affiliatepro', $data));
			}
		}
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/affiliatepro')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}